<?php

/**
 * @package Plugin Page Navigation Titles for Joomla! 1.5
 * @version $Id: pagenavtitles.php 456 2010-08-28 17:00:30Z kir $
 * @author Kirill Mazur
 * @copyright Copyright (C) 2010 - Kirill Mazur
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
 **/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.event.plugin' );

class plgContentPageNavTitles extends JPlugin
{

	function plgContentPageNavTitles( &$subject, $params )
	{
		parent::__construct( $subject, $params );
		$lang = & JFactory::getLanguage();
		$lang->load('plg_content_pagenavtitles', JPATH_ADMINISTRATOR);
	}

	function onPrepareContent( &$row, &$params)
	{
		$plugin =& JPluginHelper::getPlugin('content', 'pagenavtitles');
		$option = JRequest::getVar('option', null);
		$view = JRequest::getVar('view', null);

		if (($option=="com_content") && ($view == 'article') && $params->get('show_item_navigation')){

			$html 		= '';
			$db 		= & JFactory::getDBO();
			$user		= & JFactory::getUser();
			$nullDate	= $db->getNullDate();

			$date		= & JFactory::getDate();
			$config 	= & JFactory::getConfig();
			$now 		= $date->toMySQL();

			$uid 		= $row->id;

			$canPublish = $user->authorize('com_content', 'publish', 'content', 'all');

			// the following is needed as different menu items types utilise a different param to control ordering
			// for Blogs the `orderby_sec` param is the order controlling param
			// for Table and List views it is the `orderby` param
			$params_list = $params->toArray();
			if (array_key_exists('orderby_sec', $params_list)) {
				$order_method = $params->get('orderby_sec', '');
			} else {
				$order_method = $params->get('orderby', '');
			}
			// additional check for invalid sort ordering
			if ( $order_method == 'front' ) {
				$order_method = '';
			}

			// Determine sort order
			switch ($order_method)
			{
				case 'date' :
					$orderby = 'a.created';
					break;

				case 'rdate' :
					$orderby = 'a.created DESC';
					break;

				case 'alpha' :
					$orderby = 'a.title';
					break;

				case 'ralpha' :
					$orderby = 'a.title DESC';
					break;

				case 'hits' :
					$orderby = 'a.hits';
					break;

				case 'rhits' :
					$orderby = 'a.hits DESC';
					break;

				case 'order' :
					$orderby = 'a.ordering';
					break;

				case 'author' :
					$orderby = 'a.created_by_alias, u.name';
					break;

				case 'rauthor' :
					$orderby = 'a.created_by_alias DESC, u.name DESC';
					break;

				case 'front' :
					$orderby = 'f.ordering';
					break;

				default :
					$orderby = 'a.ordering';
					break;
			}

			$xwhere = ' AND ( a.state = 1 OR a.state = -1 )' .
		' AND ( publish_up = '.$db->Quote($nullDate).' OR publish_up <= '.$db->Quote($now).' )' .
		' AND ( publish_down = '.$db->Quote($nullDate).' OR publish_down >= '.$db->Quote($now).' )';

			// array of articles in same category correctly ordered
			$query = 'SELECT a.id,a.title,'
			. ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'
			. ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug'
			. ' FROM #__content AS a'
			. ' LEFT JOIN #__categories AS cc ON cc.id = a.catid'
			. ' WHERE a.catid = ' . (int) $row->catid
			. ' AND a.state = '. (int) $row->state
			. ($canPublish ? '' : ' AND a.access <= ' .(int) $user->get('aid', 0))
			. $xwhere
			. ' ORDER BY '. $orderby;
			$db->setQuery($query);
			$list = $db->loadObjectList('id');
				
			// this check needed if incorrect Itemid is given resulting in an incorrect result
			if ( !is_array($list) ) {
				$list = array();
			}

			reset($list);

			// location of current content item in array list
			$location = array_search($uid, array_keys($list));

			$rows = array_values($list);

			$row->prev = null;
			$row->next = null;

			if ($location -1 >= 0) 	{
				// the previous content item cannot be in the array position -1
				$row->prev = $rows[$location -1];
			}

			if (($location +1) < count($rows)) {
				// the next content item cannot be in an array position greater than the number of array postions
				$row->next = $rows[$location +1];
			}

			$pnSpace = "";
			if (JText::_('&lt') || JText::_('&gt')) {
				$pnSpace = " ";
			}

			if ($row->prev) {
				$row->prevTitle=$row->prev->title;
				$row->prev = JRoute::_(ContentHelperRoute::getArticleRoute($row->prev->slug, $row->prev->catslug));
			} else {
				$row->prev = '';
				$row->prevTitle = '';
			}

			if ($row->next) {
				$row->nextTitle=$row->next->title;
				$row->next = JRoute::_(ContentHelperRoute::getArticleRoute($row->next->slug, $row->next->catslug));
			} else {
				$row->next = '';
				$row->nextTitle= '';
			}

			// Get the plugin parameters
			$pluginParams = new JParameter( $plugin->params );
			$position = $pluginParams->get('position', 1);
			$prevnext = $pluginParams->get('prevnext');
			if ($prevnext) {$prev = JText::_('Prev'); $next = JText::_('Next');} else {$prev = ''; $next = '';}

			// output
			if ($row->prev || $row->next)
			{
				$html = '
			<table align="center" class="pagenav">
			<tr>'
			;
			if ($row->prev)
			{
				$html .= '
				<th class="pagenav_prev">
				  
					<a href="'. $row->prev .'" title="' .$row->prevTitle. '">'
					. JText::_( '<big>&larr;</big>' ) . $prev . $pnSpace . $row->prevTitle .'</a>
				</th>'
				;
			}

			if ($row->prev && $row->next)
			{
				$html .= '
				<td width="50">
					&nbsp;
				</td>'
				;
			}

			if ($row->next)
			{
				$html .= '
				<th class="pagenav_next">
					<a href="'. $row->next .'" title="' .$row->nextTitle. '">'
					. $row->nextTitle . $pnSpace . $next . JText::_( '<big>&rarr;</big>' ).'</a>
				</th>'
				;
			}
			$html .= '
			</tr>
			</table>'
			;

			if ($position) {
				// display after content
				$row->text .= $html;
			} else {
				// display before content
				$row->text = $html . $row->text;
			}
			}
		}

		return ;
	}
}

?>